<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Token Screen</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
    <link rel="SHORTCUT ICON" href="layouts/v7/skins/images/favicon.ico">
    <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300..800;1,300..800&display=swap" rel="stylesheet">


</head>
<style>
body{
font-family: "Open Sans", sans-serif;
font-optical-sizing: auto;
font-weight: 700;
font-style: normal;
font-variation-settings:"wdth" 100;
background-color:#EEECEC;
}
table{
    box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
}
tr{
    border:2px solid black;
}
</style>
<body>
    <div class="container">
    <h3 class="text-center">Token Screen</h3>
    <h5>Date: <span id="displayDate"></span></h5>
    </div>

    <div class="container">
    <table class="table table-bordered">
  <thead class="thead-dark">
    <tr>
      <th scope="col">Token No#</th>
      <th scope="col">Prisoner name</th>
      <th scope="col">Father/Husband</th>
      <th scope="col">Visitor Name</th>
      <th scope="col">Chamber</th>
      <th scope="col">Slot(Time)</th>
    </tr>
  </thead>
  <tbody id="tokenScreenData"></tbody>
</table>
    </div>
    
</body>

<script
  src="https://code.jquery.com/jquery-3.7.1.min.js"
  integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo="
  crossorigin="anonymous"></script>

<script>
$(document).ready(function() {
	var currentPage = 0;
    function fetchTokenScreenData() {
        var tokenData = '';
        
        $.ajax({
            type: 'POST',
            dataType: 'text',
	    url: 'getTokenScreenData.php',
	    data: { page: currentPage },
            success: function(res) {
                console.log(res);
                var datares = JSON.parse(res);
                tokenData = ''; // Clear tokenData to avoid duplication

		 if (datares.result && Array.isArray(datares.result)) {

                	datares.result.map((res) => {
	                    $('#displayDate').html(res.todayDate);

			    currentPage = res.page;

        	            var startEndTime = res.startTime + ' - ' + res.endTime;
                	    tokenData += "<tr style='height:2px;'><td>" + res.tokenNumber + "</td><td>" + res.lastName + "</td><td>" + res.prisonerParent + "</td><td>" + res.visitorName + "</td><td>" + res.chamberNumber + "</td><td>" + startEndTime + "</td></tr>";
                	});
                
                	// Update the table content outside of the map function
			document.getElementById("tokenScreenData").innerHTML = tokenData;

			// Move to next page
			currentPage++;
	    	}
            },
            error: function(xhr, status, error) {
                console.error("Error fetching data:", error);
            }
        });
    }

    // Call fetchTokenScreenData immediately when the document is ready
    fetchTokenScreenData();

    // Set interval to call fetchTokenScreenData every 30 seconds
    setInterval(fetchTokenScreenData, 15000);
});

/*$(document).ready(function(){
        var tokenData = '';

        $.ajax({
        type: 'POST',
        dataType: 'text',
        url: 'getTokenScreenData.php',
        // data: {
        //     'postTime':selectedOption
        // },
        success:function(res){
        
        console.log(res);
        var datares = JSON.parse(res);
        datares.result.map((res) => {

            $('#displayDate').html(res.todayDate);

            var startEndTime = res.startTime+' - '+res.endTime;
          tokenData +="<tr style='height:2px;'><td>"+res.tokenNumber+"</td><td>"+res.lastName+"</td><td>"+res.prisonerNumber+"</td><td>"+res.chamberNumber+"</td><td>"+startEndTime+"</td></tr>";
          document.getElementById("tokenScreenData").innerHTML = tokenData;
          });
        } 
                                  
    });
});*/
</script>
</html>
