 /*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/


Vtiger_Edit_Js("HelpDesk_Edit_Js",{
    

},{
   
    //astCRM-start

    registerReadonlyFields: function() {
        // Make PID field readonly
        var pidField = jQuery('[name="p_i_d"]');
        pidField.prop('readonly', true);

        // Make Father / Husband field readonly
        var parentRefField = jQuery('[name="parent_ref"]');
        parentRefField.prop('readonly', true);

    },

    registerPrisonerSelectionEvent: function (container) {
        var thisInstance = this;
        if(app.getModuleName() == 'HelpDesk'){
            jQuery('input[name="contact_id"]', container).on(Vtiger_Edit_Js.referenceSelectionEvent, function (e, data) {
            var sourceModule = data['source_module'];
           //alert(sourceModule);
            thisInstance.getRecordDetails(data).then(
                    function (response) {
                        var result = response['data'];
                        container.find('[name="p_i_d"]').val(result.prisoner_uniqueno);
                        container.find('[name="parent_ref"]').val(result.parent_name);
                    },
                    function (error, err) {

                    });
        });

        }
       
    },
    //astCRM-end
      
    /** 
     * Function to register Basic Events
     * @returns {undefined}
     */
    registerBasicEvents : function(form){
        app.event.on('post.editView.load',function(event,container){
        });
        this.registerEventForPicklistDependencySetup(form);
        this.registerFileElementChangeEvent(form);
        this.registerAutoCompleteFields(form);
        this.registerClearReferenceSelectionEvent(form);
        this.registerReferenceCreate(form);
        this.referenceModulePopupRegisterEvent(form);
	this.registerReadonlyFields();
        this.registerPostReferenceEvent(this.getEditViewContainer());
        this.registerPrisonerSelectionEvent(this.getEditViewContainer());//AstCRM
    },
    
});
