// Show registration steps after 2 seconds
window.onload = function () {
    setTimeout(() => {
        // Hide the welcome screen
        document.getElementById("welcome-screen").style.display = "none";

        // Show the registration steps
        document.getElementById("registration-steps").style.display = "block";
    }, 2000); // 2 seconds delay
};

document.addEventListener("DOMContentLoaded", function () {
    const steps = document.querySelectorAll(".form-step");
    const nextButtons = document.querySelectorAll(".next");
    const prevButtons = document.querySelectorAll(".prev");
    const stepsProgress = document.querySelectorAll(".step");

	// Next button event listener
    nextButtons.forEach((btn) => {
        btn.addEventListener("click", function () {
            const currentStepIndex = parseInt(btn.dataset.next) - 2; // Current step index
            const currentStep = steps[currentStepIndex];

            if (validateStep(currentStep)) {
                updateFormStep(currentStepIndex + 1);
            }
        });
    });

    // Previous button event listener
    prevButtons.forEach((btn) => {
        btn.addEventListener("click", function () {
            const currentStepIndex = parseInt(btn.dataset.prev) - 1; // Current step index
            const currentStep = steps[currentStepIndex + 1]; // Identify the current step
            const previousStep = steps[currentStepIndex]; // Identify the previous step

            // Hide the current step and show the previous step
            currentStep.classList.remove("active");
            previousStep.classList.add("active");

            // Update progress bar
            stepsProgress.forEach((step, index) => {
                if (index <= currentStepIndex) {
                    step.classList.add("active");
                } else {
                    step.classList.remove("active");
                }
            });
        });
    });

    // Validate the current step
    function validateStep(step) {
        const inputs = step.querySelectorAll("input[required]");
        let isValid = true;

        inputs.forEach((input) => {
            if (input.value.trim() === "") {
                input.classList.add("invalid");
                isValid = false;
            } else {
                input.classList.remove("invalid");
            }

            // Check field validity
            if (!input.checkValidity()) {
                input.reportValidity();
                isValid = false;
            }
        });

        return isValid;
    }

    // Update active step in the progress bar and form
    function updateFormStep(currentStepIndex) {
        // Update progress bar
        stepsProgress.forEach((step, index) => {
            if (index <= currentStepIndex) {
                step.classList.add("active");
            } else {
                step.classList.remove("active");
            }
        });

        // Show the appropriate form step
        steps.forEach((step, index) => {
            step.classList.toggle("active", index === currentStepIndex);
        });
    }
});

document.addEventListener("DOMContentLoaded", function () {
    const passwordInput = document.getElementById("password");
    const confirmPasswordInput = document.getElementById("confirm-password");
    const passwordError = document.getElementById("password-error");
    const passwordMismatch = document.getElementById("password-mismatch");
    const nextButton = document.querySelector('button[data-next="2"]');

    // Function to validate password strength
    function validatePassword(password) {
        const regex = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/;
        return regex.test(password);
    }

    // Password input event listener
    passwordInput.addEventListener("input", function () {
        const password = passwordInput.value;

        if (!validatePassword(password)) {
            passwordInput.classList.add("invalid");
            passwordError.textContent =
                "Password must include uppercase, lowercase, digit, special character, and be at least 8 characters.";
            nextButton.disabled = true;
        } else {
            passwordInput.classList.remove("invalid");
            passwordError.textContent = "";
            nextButton.disabled = false;
        }
    });

    // Confirm password input event listener
    confirmPasswordInput.addEventListener("input", function () {
        const password = passwordInput.value;
        const confirmPassword = confirmPasswordInput.value;

        if (password !== confirmPassword) {
            confirmPasswordInput.classList.add("invalid");
            passwordMismatch.textContent = "Passwords do not match.";
            nextButton.disabled = true;
        } else {
            confirmPasswordInput.classList.remove("invalid");
            passwordMismatch.textContent = "";
            nextButton.disabled = false;
        }
    });
});


    $(document).ready(function() {

	      if ($('#frequency').length > 0) {
        console.log('Frequency dropdown found!');
    } else {
        console.error('Frequency dropdown not found!');
    }


	     $('#frequency').change(function() {
        var selectedValue = $(this).val(); // Get the selected value
        console.log('Selected Frequency:', selectedValue);
    });


        $('.submit').on('click', function() {
            // Collect form data from all steps
            var formData = new FormData();

            // Step 1 data
            formData.append('name', $('#name').val());
            formData.append('email', $('#email').val());
            formData.append('password', $('#password').val());
            formData.append('confirm-password', $('#confirm-password').val());

            // Step 2 data
            formData.append('mobile', $('#mobile').val());
            formData.append('city', $('#city').val());
            formData.append('postal-code', $('#postal-code').val());

		var frequency = $('#frequency').val(); // Get the selected value
        console.log('Selected Frequency:', frequency);

        if (!selectedValue) {
            toastr.error('Please select a frequency!');
        }
            formData.append('frequency', frequency);

            // AJAX request using jQuery
            $.ajax({
                url: '../submit_registration.php',
                type: 'POST',
                data: formData,
                dataType: 'text',
     	        processData: false, // Prevent jQuery from processing the data
                contentType: false, // Prevent jQuery from setting content type header
                success: function(response) {
                    // Handle successful submission (show a success message, etc.)
     		    toastr.error("Already Exists. Please Login", "Record Found");

// Redirect after 2 seconds (2000 milliseconds)
setTimeout(function() {
    window.location.href = "http://192.168.10.129/vms/"; // Replace with the desired URL
}, 2000);
			
                },
                error: function() {
                    // Handle error (show an error message)
                    //alert('Registration failed');
                	  toastr.success("Successfully Created", "Record Created");

			// Redirect after 2 seconds (2000 milliseconds)
			setTimeout(function() {
			    window.location.href = "http://192.168.10.129/vms/"; // Replace with the desired URL
			}, 2000);

		}
            });
        });
    });



