<?php
date_default_timezone_set("Asia/Calcutta");   //India time (GMT+5:30)

include 'config.inc.php';

$hostname = $dbconfig['db_server'];
$username = $dbconfig['db_username'];
$password = $dbconfig['db_password'];
$dbName   = $dbconfig['db_name'];

// Create connection
$conn = new mysqli($hostname, $username, $password,$dbName);

// Check connection
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}
// echo "Connected successfully";


//
$timeNow = date('H:i');

//Every 15 Min 
$currentHour = date('H');
$currentMinute = date('i');

// Round up the current time to the nearest 15-minute interval
$roundedMinutes = ceil($currentMinute / 15) * 15;

// If rounded minutes exceed 59, adjust hours and set minutes to 0
if ($roundedMinutes == 60) {
    $currentHour = ($currentHour + 1) % 24;
    $roundedMinutes = 0;
}

// Format the start time
$startTime = sprintf('%02d:%02d', $currentHour, $roundedMinutes);
$endTime   = date('H:i', strtotime($startTime . ' +15 minutes'));

$limit = 10;
$page = isset($_POST['page']) ? (int)$_POST['page'] : 0;
$offset = $page * $limit;

$today = date('Y-m-d');
$tokenScreenData = array();

// Count total rows
$countQuery = "SELECT COUNT(DISTINCT t1.token_no) as total FROM visitor_token t1 
JOIN vtiger_troubletickets t2 ON t1.token_no = t2.token_number 
WHERE t1.visit_date = '$today' AND t2.status = 'Planned'";
$countRes = $conn->query($countQuery);
$totalRows = $countRes->fetch_assoc()['total'] ?? 0;

// Reset if offset exceeds total rows
if ($offset >= $totalRows) {
	$offset = 0;
	$page = 0;
}

$getTokenData = "SELECT DISTINCT t1.* FROM visitor_token t1 JOIN vtiger_troubletickets t2 ON t1.token_no = t2.token_number WHERE t1.visit_date = '$today' AND t2.status = 'Planned' order by t1.token_no LIMIT $limit OFFSET $offset";
$res = $conn->query($getTokenData);
if($res->num_rows > 0){
    while($row = $res->fetch_assoc()){
        $tokenNumber = $row['token_no'];
        $prisonerId = $row['prisnor_id'];
        $visitorId = $row['visitor_id'];
        $visitDate = $row['visit_date'];
        $visitTimeStart = $row['visit_time_start'];
        $visitTimeEnd = $row['visit_time_end'];
        $chamber = $row['chamber'];
	
	$getVisitor = "SELECT title FROM vtiger_troubletickets WHERE ticketid = '$visitorId'";
        $resVisitor = mysqli_query($conn,$getVisitor);
        $rowVisitor = mysqli_fetch_assoc($resVisitor);

	$visitorName = $rowVisitor['title'];

        //get prisoner data
        $getPrisoner = "SELECT lastname,contactid,contact_no,prisoner_uniqueno, parent_name FROM vtiger_contactdetails WHERE contactid = '$prisonerId'";
        $resPrisoner = mysqli_query($conn,$getPrisoner);
	$rowPrisoner = mysqli_fetch_assoc($resPrisoner);
	$prisonerName = $rowPrisoner['lastname'];
        $prisonerNumber = $rowPrisoner['contact_no'];
        $prisonerUniqueno = $rowPrisoner['prisoner_uniqueno'];
        $prisonerParent = $rowPrisoner['parent_name'];
       
        
	if($timeNow <= $visitTimeEnd){     
		/*array_push($tokenScreenData,array(
	    'lastName'=>$prisonerName,
	    'visitorName'=>$visitorName,
            'tokenNumber'=>$tokenNumber,
            'chamberNumber'=>$chamber,
            'startTime'=>date("g:i A", strtotime($visitTimeStart)),
            'endTime'=>date("g:i A", strtotime($visitTimeEnd)),
            'prisonerNumber'=>$prisonerUniqueno,
            'prisonerParent'=>$prisonerParent,
	    'visitDate'=>$visitDate,
	    'page'=>$page,
            'todayDate'=>date('d-m-Y',strtotime($today))
		));*/

		//print_r($tokenScreenData);
	}
    else{
        $updt = "UPDATE vtiger_troubletickets SET status = 'Closed' where ticketid = '$visitorId'";
        $conn->query($updt);
    }

	 array_push($tokenScreenData,array(
            'lastName'=>$prisonerName,
            'visitorName'=>$visitorName,
            'tokenNumber'=>$tokenNumber,
            'chamberNumber'=>$chamber,
            'startTime'=>date("g:i A", strtotime($visitTimeStart)),
            'endTime'=>date("g:i A", strtotime($visitTimeEnd)),
            'prisonerNumber'=>$prisonerUniqueno,
            'prisonerParent'=>$prisonerParent,
            'visitDate'=>$visitDate,
            'page'=>$page,
            'todayDate'=>date('d-m-Y',strtotime($today))
        ));
   
    }

   
    echo json_encode(array("result"=>$tokenScreenData));
    
}else{
    echo json_encode(array("result"=>'No Data'));
}

?>
